ENYX_CORES_NAMESPACE_BEGIN
namespace ethernet_filter {

inline
ethernet_filter::ethernet_filter(enyx::hw::core const& ethernet_filter_core)
    : ethernet_filter_core_(ethernet_filter_core),
      ethernet_filter_(::enyx_ethernet_filter_create(ethernet_filter_core_.handle()))
{
    if (! ethernet_filter_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create ethernet_filter"};
}

inline enyx::hw::core
ethernet_filter::get_core() const noexcept
{
    return ethernet_filter_core_;
}

inline bool
ethernet_filter::enabled() const noexcept
{
    return ::enyx_ethernet_filter_is_enabled(handle());
}

inline result<void>
ethernet_filter::enable() noexcept
{
    if (::enyx_ethernet_filter_enable(handle()) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline result<void>
ethernet_filter::disable() noexcept
{
    if (::enyx_ethernet_filter_disable(handle()) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline bool
ethernet_filter::unicast_promiscuous_enabled() const noexcept
{
    return ::enyx_ethernet_filter_unicast_promiscuous_enabled(handle());
}

inline result<void>
ethernet_filter::enable_unicast_promiscuous() noexcept
{
    if (::enyx_ethernet_filter_enable_unicast_promiscuous(handle()) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline result<void>
ethernet_filter::disable_unicast_promiscuous() noexcept
{
    if (::enyx_ethernet_filter_disable_unicast_promiscuous(handle()) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline result<bool>
ethernet_filter::udp_session_copy_enabled(std::uint16_t udp_session_id) const noexcept
{
    bool enabled;
    if (::enyx_ethernet_filter_udp_session_copy_enabled(handle(),
                                                        udp_session_id,
                                                        &enabled) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return enabled;
}

inline result<void>
ethernet_filter::enable_udp_session_copy(std::uint16_t udp_session_id) noexcept
{
    if (::enyx_ethernet_filter_enable_udp_session_copy(handle(),
                                                       udp_session_id) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline result<void>
ethernet_filter::disable_udp_session_copy(std::uint16_t udp_session_id) noexcept
{
    if (::enyx_ethernet_filter_disable_udp_session_copy(handle(),
                                                        udp_session_id) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline enyx::result<std::uint32_t>
ethernet_filter::get_packet_fifo_out_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_ethernet_filter_get_packet_fifo_out_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline enyx::result<std::uint32_t>
ethernet_filter::get_packet_filter_drop_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_ethernet_filter_get_packet_filter_drop_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline enyx::result<std::uint32_t>
ethernet_filter::get_packet_filter_out_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_ethernet_filter_get_packet_filter_out_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline enyx::result<std::uint8_t>
ethernet_filter::get_filtered_data_width() const noexcept
{
    std::uint8_t result;

    if (::enyx_ethernet_filter_get_filtered_data_width(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline ::enyx_ethernet_filter *
ethernet_filter::handle() const noexcept
{
    return ethernet_filter_.get();
}

} /* namespace ethernet_filter */
ENYX_CORES_NAMESPACE_END
