ENYX_CORES_NAMESPACE_BEGIN
namespace data_stream {

template<typename Handler>
inline
hw_source::hw_source(hw::a2c_stream & stream, Handler && handler)
    : stream_(stream)
    , next_source_(make_source(std::forward<Handler>(handler)))
{ }

inline result<int>
hw_source::poll_once() noexcept
{
    return ::enyx_data_stream_hw_source_poll_once(stream_.handle(),
                                         next_source_->handle());
}

} /* namespace data_stream */
ENYX_CORES_NAMESPACE_END
