"""Core type"""

from typing import List

from .variable import Enum, Page
from .variable import VariableContainer
from .utils import chain_variables


class Core(VariableContainer):
    """Represent an hardware core
    """
    def __init__(self, name: str, major: int, minor: int, revision: int,
                 hardware_id: int, variables: List[object]):
        # pylint: disable=too-many-arguments
        super().__init__(name)
        self.major = major
        self.minor = minor
        self.revision = revision
        self.hardware_id = hardware_id
        variables = list(variables)
        self.variables_ = list(filter(lambda v:
                                      not isinstance(v, Page)
                                      and not isinstance(v, Core),
                                      variables))
        self.pages_ = list(filter(lambda v: isinstance(v, Page), variables))
        self.cores = list(filter(lambda v: isinstance(v, Core), variables))

    @property
    def variables(self):
        """List variables of a core"""
        return tuple(chain_variables(self.variables_))

    @property
    def pages(self):
        """List pages of a core"""
        return tuple(self.pages_)

    @property
    def enums(self):
        """List enums of a core"""
        return tuple(filter(lambda v: isinstance(v, Enum), self.variables))
