/*
 * HFP rx core interface.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HFP_RX_DEV_H
#define HFP_RX_DEV_H

#include <linux/kernel.h>

#include "enyx_hfp_bus.h"

#define HFP_RX_DEV_CHANNEL_ATTR_PTR_FEEDBACK (1)

typedef void
(*enyx_hfp_rx_on_interrupt)(uint16_t channel_id, void * opaque);

typedef void
(enyx_hfp_rx_on_data)(const uint8_t * data, uint32_t size, void * opaque);

struct enyx_hfp_rx_dev
{
    size_t
    (*get_mtu)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_alignment)(struct enyx_hfp_rx_dev * dev);

    size_t
    (*get_buffers_size)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_ctrl_size)(struct enyx_hfp_rx_dev * dev);

    size_t
    (*get_ptrs_size)(struct enyx_hfp_rx_dev * dev);

    size_t
    (*get_channel_count)(struct enyx_hfp_rx_dev * dev);

    int
    (*enable_channel)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id, int attr);

    void
    (*disable_channel)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_usage)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id,
                 char * buffer, size_t buffer_size);

    size_t
    (*get_packet_count)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_backpressure_count)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_fifo_errors)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_errors)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    size_t
    (*get_truncated_count)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    int
    (*poll_one)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id,
                enyx_hfp_rx_on_data on_data, void * opaque);

    int
    (*arm_interrupt)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    int
    (*disarm_interrupt)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    int
    (*update_rd_ptr)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    int
    (*mmap_ctrl)(struct enyx_hfp_rx_dev * dev, struct vm_area_struct * vma,
                 uint16_t channel_id);

    int
    (*mmap_ptrs)(struct enyx_hfp_rx_dev * dev, struct vm_area_struct * vma,
                 uint16_t channel_id);

    int
    (*mmap_data)(struct enyx_hfp_rx_dev * dev, struct vm_area_struct * vma,
                 uint16_t channel_id);

    int
    (*alloc_dma_data_buffer)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    void
    (*free_dma_data_buffer)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    int
    (*set_buffer_width)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id,
                             size_t new_buffer_width);

    size_t
    (*get_buffer_width)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);

    int
    (*set_default_buffer_width)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id,
                             size_t new_buffer_width);

    size_t
    (*get_default_buffer_width)(struct enyx_hfp_rx_dev * dev, uint16_t channel_id);
};

struct enyx_hfp_rx_dev *
enyx_hfp_rx_dev_create(struct enyx_hfp_device * parent,
                  enyx_hfp_rx_on_interrupt on_interrupt,
                  void * opaque,
                  size_t buffers_size_shift,
                  size_t coherency_line_size);

void
enyx_hfp_rx_dev_destroy(struct enyx_hfp_rx_dev * bus);

#endif /* HFP_RX_DEV_H */

