/*
 * HFP id module.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <linux/version.h>
#include <linux/slab.h>
#include <linux/module.h>

#include "enyx_hfp_common.h"
#include "enyx_hfp_id_usr.h"

static int __init
init_this_module(void)
{
    int err;

    pr_info("%s %s <support@enyx.com>\n",
            MODULE_NAME, ENYX_HFP_MODULES_VERSION);

    err = enyx_hfp_id_class_register();
    if (err < 0)
        goto enyx_hfp_id_class_register_failed;

    return 0;

enyx_hfp_id_class_register_failed:
    return err;
}

module_init(init_this_module);

static void __exit
exit_this_module(void)
{
    enyx_hfp_id_class_unregister();
    pr_debug("%s Exited\n", MODULE_NAME);
}

module_exit(exit_this_module);

MODULE_AUTHOR("David Keller <david.keller@enyx.com>");
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("Hfp id module");
MODULE_VERSION(ENYX_HFP_MODULES_VERSION);

