/**
 *  @file
 *
 *  Contains the types and functions related to the
 *  cores registers.
 */
#pragma once

#include <stdint.h>

/**
 * This class is a core register.
 *
 * It defines the register attributes (e.g. offset, size, direction)
 *
 * @since 5.0.0
 */
typedef struct {
    /**
     * Define the register byte-offset from the core base address
     *
     * @since 5.0.0
     */
    uint64_t byte_offset;

    /**
     * Define the register bit-offset from the byte-offset
     *
     * @since 5.0.0
     */
    uint8_t bit_offset;

    /**
     * Define the register size in bits.
     *
     * @since 5.0.0
     */
    uint8_t bit_width;
} enyx_hw_register_description;

/**
 * This class is a core register, with its name.
 *
 * @since 5.0.0
 */
typedef struct {
    /**
     * The register name.
     *
     * @since 5.0.0
     */
    char name[128];

    /**
     * The associated core register.
     *
     * @since 5.0.0
     */
    enyx_hw_register_description reg;
} enyx_hw_named_register;
