ENYX_HW_NAMESPACE_BEGIN

inline
core_descriptions::core_descriptions(
        std::shared_ptr<enyx_hw_core_descriptions> const & descriptions) noexcept
    : descriptions_(descriptions)
{}

inline
core_descriptions::core_descriptions() noexcept
    : core_descriptions(make_core_descriptions_ptr(enyx_hw_core_descriptions_from_scratch()))
{}

inline
core_descriptions
core_descriptions::operator+=(const core_descriptions & rhs)
{
    if (enyx_hw_core_descriptions_merge(handle(), rhs.handle()) == NULL)
        throw std::system_error(errno, std::generic_category());
    return *this;
}

inline
core_descriptions
operator+(core_descriptions lhs, core_descriptions const & rhs)
{
    lhs += rhs;
    return lhs;
}

inline
result<void>
core_descriptions::add_core_description(core_description const& core) noexcept
{
    if (enyx_hw_core_descriptions_add_core(handle(), core.handle()) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline
result<core_description>
core_descriptions::find(core const & c) const noexcept
{
    return find(c.get_descriptor());
}

inline
result<core_description>
core_descriptions::find(core::descriptor_type const & descriptor) const noexcept
{
    enyx_hw_core_description * descr;
    if ((descr = enyx_hw_core_descriptions_find_by_desc(handle(), &descriptor)) == NULL)
        return {std::error_code{errno, std::generic_category()}};

    auto descr_ptr = make_core_description_ptr(descr);

    return {enyx::hw::core_description{descr_ptr}};
}

inline
result<std::uint16_t>
core_descriptions::get_hardware_id(std::string const & name) const noexcept
{
    std::uint16_t out;
    if (enyx_hw_core_descriptions_get_hardware_id(handle(), name.c_str(), &out) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {out};
}

inline
result<std::string>
core_descriptions::get_name(std::uint16_t hardware_id) const noexcept
{
    char out[128];
    if (enyx_hw_core_descriptions_get_name(handle(), hardware_id, out, 128) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {out};
}

inline
enyx_hw_core_descriptions *
core_descriptions::handle() noexcept
{
    return descriptions_.get();
}

inline
enyx_hw_core_descriptions const *
core_descriptions::handle() const noexcept
{
    return descriptions_.get();
}

inline
std::shared_ptr<enyx_hw_core_descriptions>
make_core_descriptions_ptr(enyx_hw_core_descriptions * descriptions)
{
    if (descriptions == nullptr)
        throw std::system_error{EINVAL, std::generic_category()};
    return std::shared_ptr<enyx_hw_core_descriptions>{
        descriptions, &enyx_hw_core_descriptions_destroy
    };
}

inline
result<core_descriptions>
core_descriptions_from_xml(std::string const & file) noexcept
{
    auto descriptions = enyx_hw_core_descriptions_from_xml(file.c_str());
    if (descriptions == nullptr)
        return {std::error_code{errno, std::generic_category()}};
    return {make_core_descriptions_ptr(descriptions)};
}

inline
result<void>
validate_xml_core_descriptions(std::string const & xml_file,
                               std::string const & xsd_file) noexcept
{
    if (enyx_hw_core_descriptions_validate_xml_file(xml_file.c_str(),
                                               xsd_file.c_str()) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

ENYX_HW_NAMESPACE_END
