ENYX_HW_NAMESPACE_BEGIN

inline
core_description::named_register::named_register(
        std::string const & n,
        register_description const & d)
    : name(n), description(d)
{
}

inline
core_description::core_description(core_name const & name,
                                   core::descriptor_type const & descriptor)
    : description_(make_core_description_ptr(
                    enyx_hw_core_descr_new(name.c_str(), &descriptor)
                   ))
{
    if (description_ == nullptr)
        throw std::system_error{errno, std::generic_category()};
}

inline
core_description::core_description(std::shared_ptr<enyx_hw_core_description> description)
    : description_(description)
{
}

inline core_description::core_name
core_description::get_name() const noexcept
{
    char name[128];
    enyx_hw_core_descr_get_name(handle(), name, sizeof(name));
    return {name};
}

inline
typename core::descriptor_type
core_description::get_associated_core_descriptor() const noexcept
{
    core::descriptor_type ret;
    enyx_hw_core_descr_get_descriptor(handle(), &ret);
    return ret;
}

inline
result<void>
core_description::add_register_description(std::string const & name, register_description const & reg) noexcept
{
    if (enyx_hw_core_descr_add_register_desc(handle(), name.c_str(), &reg) != 0)
        return {std::error_code(errno, std::generic_category())};
    return {};
}

inline
result<register_description>
core_description::find_register(std::string const & name) const noexcept
{
    register_description ret;
    if (enyx_hw_core_descr_find_register(handle(), name.c_str(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline
core_description::named_registers
core_description::get_all_registers() const noexcept
{

    std::vector<enyx_hw_named_register>
        registers(enyx_hw_core_descr_count_registers(handle()));

    enyx_hw_core_descr_get_all_registers(handle(), registers.data(),
                                         registers.size());
    core_description::named_registers ret;
    for (auto const & reg: registers)
        ret.emplace_back(reg.name, reg.reg);
    return ret;
}

inline
enyx_hw_core_description *
core_description::handle() noexcept
{
    return description_.get();
}

inline
enyx_hw_core_description const *
core_description::handle() const noexcept
{
    return description_.get();
}

inline
std::shared_ptr<enyx_hw_core_description>
make_core_description_ptr(enyx_hw_core_description * description)
{
    if (description == nullptr)
        throw std::system_error{EINVAL, std::generic_category()};
    return {description, &enyx_hw_core_descr_destroy};
}

ENYX_HW_NAMESPACE_END
