#pragma once

#include <atomic>
#include <exception>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

void
install_signal_handlers();

bool
is_exit_requested();

void
request_exit();

// Request exit is this object is destruct while stack is unwinding
// (i.e. an exception has been thrown)
struct exit_on_exception
{
    ~exit_on_exception()
    {
        if (std::uncaught_exception())
            request_exit();
    }
};

ENYX_CORES_NAMESPACE_END
