#include "SignalHandler.hpp"

#include <csignal>
#include <cstdlib>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

std::atomic<bool> is_exit_requested_;

bool
is_exit_requested()
{
    return is_exit_requested_.load(std::memory_order_acquire);
}

void
request_exit()
{
    is_exit_requested_.store(true, std::memory_order_release);
}

void
install_signal_handlers()
{
    auto signal_handler = [] (int sig) {
        if (is_exit_requested())
            std::exit(1);

        request_exit();
    };

    std::signal(SIGTERM, signal_handler);
    std::signal(SIGINT, signal_handler);
}

ENYX_CORES_NAMESPACE_END
