#pragma once

#include <chrono>
#include <cstdint>
#include <string>
#include <iosfwd>
#include <vector>

#include <enyx/cores/namespace.hpp>

#include "Size.hpp"
#include "Range.hpp"

ENYX_CORES_NAMESPACE_BEGIN

struct SessionConfiguration
{
    enum Type { CLIENT, SERVER, MULTICAST };
    enum Verify { NONE, FIRST, ALL };
    enum ShutdownPolicy { WAIT_FOR_PEER, SEND_COMPLETE, RECEIVE_COMPLETE };

    std::uint32_t interface_id;
    Type type;
    Verify verify;
    std::string endpoint;
    Size send_bandwidth;
    Size mss;
    Size window;
    std::uint16_t retry_timeout;
    bool instant_ack;
    Size size;
    Range<Size> packet_size;
    ShutdownPolicy shutdown_policy;
    std::chrono::milliseconds close_delay;
};

std::istream &
operator>>(std::istream & in, SessionConfiguration::Type & type);

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration::Type & type);

std::istream &
operator>>(std::istream & in, SessionConfiguration::Verify & verify);

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration::Verify & verify);

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration & configuration);

std::istream &
operator>>(std::istream & in, SessionConfiguration::ShutdownPolicy & policy);

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration::ShutdownPolicy & policy);

using SessionConfigurations = std::vector<SessionConfiguration>;

ENYX_CORES_NAMESPACE_END
