#pragma once

#include <cstdint>
#include <vector>

#include <enyx/cores/namespace.hpp>

#include "Ranges.hpp"

ENYX_CORES_NAMESPACE_BEGIN

using CpuCoreId = std::uint32_t;

using CpuCoreIdRanges = Ranges<CpuCoreId>;

using CpuCoreIds = std::vector<CpuCoreId>;

inline CpuCoreIds
to_cpu_core_list(CpuCoreIdRanges const& cpu_core_id_ranges)
{
    return as_sequence(cpu_core_id_ranges);
}

ENYX_CORES_NAMESPACE_END
