#pragma once

#include <cstddef>
#include <cstdint>

#include <chrono>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class BandwidthThrottle
{
public:
    using Clock = std::chrono::steady_clock;

public:
    void
    reset(std::size_t bytes_per_s);

    std::size_t
    theoretical_sent_bytes() const;

private:
    std::size_t bytes_per_s_;
    Clock::time_point begin_;
};

ENYX_CORES_NAMESPACE_END
