#pragma once

#include <cstdint>

#include <iosfwd>
#include <string>

#include "CmdLine.hpp"

ENYX_CORES_NAMESPACE_BEGIN

namespace Application {

enum class StackType
{
    ALL,
    TCP_STD,
    UDP_STD,
    TCP_ULL,
    UDP_ULL,
    TCP,
    UDP,
};

std::istream &
operator>>(std::istream & in, StackType & stack_type);

void
run(CmdLineIterator i, CmdLineIterator e,
    std::string const & accelerator_index,
    StackType stack_type,
    std::uint32_t stack_index);

} // namespace Application

ENYX_CORES_NAMESPACE_END
