/**
 * @file
 *
 * Contains the types and functions related to the event.
 */
#pragma once

#include <stdint.h>

#include <enyx/cores_c/symbol_visibility.h>
#include <enyx/cores_c/probes/timestamp.h>

#include <enyx/hw_c/core.h>

/// Represents the reference id field size
typedef uint8_t enyx_probes_reference_id_size;

/// Represents the custom info field size
typedef uint8_t enyx_probes_custom_info_size;

/**
 * The probe event format
 *
 * @since 6.7.0
 */
typedef struct
{
    /// Size of the reference_id field in byte
    enyx_probes_reference_id_size reference_id_size;
    /// Size of the custom_info in byte
    enyx_probes_custom_info_size custom_info_size;
    /// The format of the timestamp
    enyx_probes_ts_format ts_format;
} enyx_probes_probe_event_format;

/**
 * The probe event
 *
 * @since 6.7.0
 */
typedef struct
{
    /// A pointer to the timestamp field
    void const * timestamp;
    /// A pointer to the reference id field
    void const * reference_id;
    /// A pointer to the custom info field
    void const * custom_info;
} enyx_probes_probe_event;

