/// @file enyx_hw_source.h
#pragma once

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#include <enyx/hw_c/a2c_stream.h>

#include <enyx/cores_c/symbol_visibility.h>
#include <enyx/cores_c/data_stream/source.h>

/**
 * Poll to receive data and invokes the @p next_source on_data handler on it.
 *
 * Usage:
 * @code
 * // ...
 * while (true)
 *     if (enyx_data_stream_hw_source_poll_once(stream, source) < 0)
 *     {
 *         perror("enyx_data_stream_hw_source_poll_once");
 *         return -1;
 *     }
 * @endcode
 * @param stream The stream to poll
 * @param next_source The source to call
 * @returns @b 1 if a message has been received
 *          (i.e. @p handler invoked); @b -1 on error (@b errno is set
 *          accordingly); otherwise @b 0.
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_data_stream_hw_source_poll_once(enyx_hw_a2c_stream * stream,
                                     enyx_data_stream_source * next_source);
