/// @file
#pragma once

#include <string>

#include <enyx/cores_c/version.h>
#include <enyx/cores/namespace.hpp>

/// @copydoc ENYX_CORES_C_VERSION
#define ENYX_CORES_VERSION ENYX_CORES_C_VERSION
/// @copydoc ENYX_CORES_C_VERSION
#define ENYX_CORES_VERSION_MAJOR ENYX_CORES_C_VERSION_MAJOR
/// @copydoc ENYX_CORES_C_VERSION
#define ENYX_CORES_VERSION_MINOR ENYX_CORES_C_VERSION_MINOR
/// @copydoc ENYX_CORES_C_VERSION
#define ENYX_CORES_VERSION_PATCH ENYX_CORES_C_VERSION_PATCH
/// @copydoc ENYX_CORES_C_VERSION_CHECK
#define ENYX_CORES_VERSION_CHECK ENYX_CORES_C_VERSION_CHECK

ENYX_CORES_NAMESPACE_BEGIN

namespace core {

/**
 * @copydoc enyx_cores_version
 *
 * @since 5.0.0
 */
std::string
version(void);

/**
 * @copydoc enyx_cores_version_check
 */
void
check_version(std::uint8_t major, std::uint8_t minor, std::uint8_t patch);

} // namespace core

ENYX_CORES_NAMESPACE_END

#include <enyx/cores/version.ipp>
