ENYX_CORES_NAMESPACE_BEGIN
namespace udp {

inline
udp::udp(enyx::hw::core const& udp_core)
    : udp_core_(udp_core),
      udp_(::enyx_udp_create(udp_core_.handle()),
           ::enyx_udp_destroy)

{
    if (! udp_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create udp"};
}

inline enyx::hw::core
udp::get_core() const noexcept
{
    return udp_core_;
}

inline result<std::string>
udp::get_name() const noexcept
{
    char buffer[128];
    ssize_t ret = ::enyx_udp_get_name(handle(),
                                          buffer,
                                          sizeof(buffer));
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return std::string{buffer};
}

inline result<std::uint16_t>
udp::get_mtu() const noexcept
{
    std::uint16_t mtu;
    if (::enyx_udp_get_mtu(handle(), &mtu) != 0)
        return std::error_code{errno, std::generic_category()};
    return mtu;
}

inline bool
udp::is_safe_mode_enabled() const noexcept
{
    return ::enyx_udp_is_safe_mode_enabled(handle());
}

inline result<void>
udp::enable_safe_mode() noexcept
{
    if (::enyx_udp_enable_safe_mode(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
udp::disable_safe_mode() noexcept
{
    if (::enyx_udp_disable_safe_mode(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<bool>
udp::is_checksum_verification_enabled() const noexcept
{
    bool enabled;
    if (::enyx_udp_is_checksum_verification_enabled(handle(), &enabled) != 0)
        return std::error_code{errno, std::generic_category()};
    return enabled;
}

inline result<void>
udp::enable_checksum_verification() noexcept
{
    if (::enyx_udp_enable_checksum_verification(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
udp::disable_checksum_verification() noexcept
{
    if (::enyx_udp_disable_checksum_verification(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline std::uint16_t
udp::get_rx_session_count() const noexcept
{
    return ::enyx_udp_get_rx_session_count(handle());
}

inline result<rx_session>
udp::get_rx_session(std::uint16_t session_id) const noexcept
{
    ::enyx_udp_rx_session c_session;
    if (::enyx_udp_get_rx_session(handle(), session_id, &c_session) != 0)
        return std::error_code{errno, std::generic_category()};
    return rx_session{udp_, c_session};
}

inline result<rx_session>
udp::get_available_rx_session() const noexcept
{
    ::enyx_udp_rx_session c_session;
    if (::enyx_udp_get_available_rx_session(handle(), &c_session) != 0)
        return std::error_code{errno, std::generic_category()};
    return rx_session{udp_, c_session};
}

inline std::uint16_t
udp::get_tx_session_count() const noexcept
{
    return ::enyx_udp_get_tx_session_count(handle());
}

inline result<tx_session>
udp::get_tx_session(std::uint16_t session_id) const noexcept
{
    ::enyx_udp_tx_session c_session;
    if (::enyx_udp_get_tx_session(handle(), session_id, &c_session) != 0)
        return std::error_code{errno, std::generic_category()};
    return tx_session{udp_, c_session};
}

inline result<tx_session>
udp::get_available_tx_session() const noexcept
{
    ::enyx_udp_tx_session c_session;
    if (::enyx_udp_get_available_tx_session(handle(), &c_session) != 0)
        return std::error_code{errno, std::generic_category()};
    return tx_session{udp_, c_session};
}

inline result<statistics>
udp::get_statistics() const noexcept
{
    statistics ret{};
    if (::enyx_udp_get_statistics(handle(), &ret) != 0)
        return std::error_code{errno, std::generic_category()};
    return ret;
}

inline ::enyx_udp *
udp::handle() const noexcept
{
    return udp_.get();
}

} /* namespace udp */
ENYX_CORES_NAMESPACE_END
