#include <system_error>

ENYX_CORES_NAMESPACE_BEGIN

namespace tcp {

inline
emi_control::emi_control(data_stream::sink const & hw_sink)
    : emi_control_(::enyx_tcp_emi_control_create(hw_sink.handle()))
{ }

inline result<void>
emi_control::set_window_size(std::uint32_t session_id, std::size_t window_size)
{
    if (::enyx_tcp_emi_control_set_window_size(handle(),
                                               session_id, window_size) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline ::enyx_tcp_emi_control *
emi_control::handle()
{
    return emi_control_.get();
}

inline ::enyx_tcp_emi_control const *
emi_control::handle() const
{
    return emi_control_.get();
}

}; /* namespace tcp */
ENYX_CORES_NAMESPACE_END
