ENYX_CORES_NAMESPACE_BEGIN

namespace probes {

template<typename OnEvent, typename OnError>
inline
source::source(OnEvent && on_event, OnError && on_error)
    : wrapper_(new wrapper<OnEvent, OnError> {
               std::forward<OnEvent>(on_event),
               std::forward<OnError>(on_error)})
    , source_(::enyx_probes_event_source_create(abstract_wrapper::on_event,
                                                  abstract_wrapper::on_error,
                                                  wrapper_.get()))
{
    if (! source_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create event context"};
}

inline
void
source::operator()(std::uint8_t const * data,
                   std::uint32_t size,
                   void const * metadata)
{
    ::enyx_probes_on_data(data, size, metadata, handle());
}

inline ::enyx_data_stream_source
source::as_next_source() const noexcept
{
    return { handle(), ::enyx_probes_on_data };
}

inline ::enyx_probes_event_source *
source::handle() const noexcept
{
    return source_.get();
}

} /* namespace probes */

ENYX_CORES_NAMESPACE_END
