ENYX_CORES_NAMESPACE_BEGIN

namespace probes {

inline
collector::collector(hw::core const & core)
    : core_(core)
    , collector_(::enyx_probes_collector_create(core_.handle()))
{
    if (! collector_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct collector"};
}

inline
collector::collector(hw::core const & root, ::enyx_probes_collector * handle)
    : core_(root)
    , collector_(handle)
{
    if (! collector_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct collector"};
}

inline ::enyx_probes_collector *
collector::handle() noexcept
{
    return collector_.get();
}

inline ::enyx_probes_collector const *
collector::handle() const noexcept
{
    return collector_.get();
}

inline std::string
collector::get_name() const
{
    return ::enyx_probes_collector_get_name(handle());
}

inline std::string
collector::get_stream_name() const
{
    return ::enyx_probes_collector_get_stream_name(handle());
}

inline std::ostream &
operator<<(std::ostream & out, collector const & p)
{
    out << "collector " << p.get_name();
    return out;
}

} /* namespace probes */

ENYX_CORES_NAMESPACE_END
