ENYX_CORES_NAMESPACE_BEGIN

namespace mm_to_st {

inline
mm_to_st::mm_to_st(enyx::hw::core & core)
    :mm_to_st_c_(enyx_mm_to_st_create(core.handle()))
{
    if (! mm_to_st_c_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create mm_to_st object."};
}

inline result<void>
mm_to_st::write(uint8_t const * buffer, size_t size) noexcept
{
    if (enyx_mm_to_st_write(handle(), buffer, size) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<size_t>
mm_to_st::get_mtu() const noexcept
{
    auto res = enyx_mm_to_st_get_mtu(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<size_t>
mm_to_st::get_data_width() const noexcept
{
    auto res = enyx_mm_to_st_get_data_width(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<size_t>
mm_to_st::get_id_width() const noexcept
{
    auto res = enyx_mm_to_st_get_id_width(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline enyx_mm_to_st const *
mm_to_st::handle() const noexcept
{
    return mm_to_st_c_.get();
}

enyx_mm_to_st *
mm_to_st::handle() noexcept
{
    return mm_to_st_c_.get();
}

} /* namespace mm_to_st */

ENYX_CORES_NAMESPACE_END
