#include <sstream>

ENYX_CORES_NAMESPACE_BEGIN

namespace hw_top {

inline
serial_id::serial_id() noexcept
    : id_()
{ }

inline
serial_id::serial_id(::enyx_hw_top_fpga_serial_id const& id) noexcept
    : id_(id)
{ }

inline std::array<std::uint8_t, serial_id::len>
serial_id::array() const noexcept
{
    std::array<std::uint8_t, len> ret{};
    std::memcpy(ret.data(), id_.value, ret.size());
    return ret;
}

inline
serial_id::operator ::enyx_hw_top_fpga_serial_id* () noexcept
{
    return &id_;
}

inline
serial_id::operator ::enyx_hw_top_fpga_serial_id const* () const noexcept
{
    return &id_;
}

inline std::ostream&
operator<<(std::ostream& out, serial_id const& serial)
{
    std::ostream::sentry sentry{out};
    if (sentry)
    {
        char buffer[2*serial_id::len + 1];
        int const ret = ::enyx_hw_top_print_fpga_serial_id(serial,
                                                           buffer,
                                                           sizeof(buffer));
        if (ret < 0)
            throw std::system_error{errno, std::generic_category(),
                                    "enyx_hw_top_print_fpga_serial_id"};

        out << buffer;
    }

    return out;
}

inline bool
operator==(serial_id const& a, serial_id const& b) noexcept
{
    return a.array() == b.array();
}

inline bool
operator!=(serial_id const& a, serial_id const& b) noexcept
{
    return ! (a == b);
}

} /* namespace hw_top */

ENYX_CORES_NAMESPACE_END
