#pragma once

#include <enyx/cores_c/data_stream/enyx_hw_sink.h>

#include <cerrno>
#include <system_error>

#include <enyx/hw/c2a_stream.hpp>

#include <enyx/cores/namespace.hpp>
#include <enyx/cores/data_stream/sink.hpp>
#include <enyx/cores/result.hpp>

ENYX_CORES_NAMESPACE_BEGIN
namespace data_stream {

/**
 *  Create a data_stream sink from an enyx hw c2a stream @p stream
 *
 *  Usage:
 *  @code
 *  auto result = enyx::data_stream::sink_from_enyx_hw_stream(c2a_stream);
 *  if (result)
 *      throw std::system_error{result.error(), "sink_from_enyx_hw_stream"};
 *  @endcode
 *  @param stream The enyx hw a2c stream to use
 *  @return the created sink
 */
result<sink>
sink_from_enyx_hw_stream(hw::c2a_stream & stream) noexcept;

} /* namespace data_stream */
ENYX_CORES_NAMESPACE_END

#include <enyx/cores/data_stream/hw_sink.ipp>
