#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <exanic/exanic.h>
#include <exanic/fifo_rx.h>
#include <exanic/util.h>

#include "gfex_hdr.h"

exanic_rx_t *rx;

int main(int argc, char*argv[])
{
    exanic_t *nic = exanic_acquire_handle(argv[1]);
    if (!nic)
    {
        fprintf(stderr, "exanic_acquire_handle: %s\n", exanic_get_last_error());
        return 1;
    }

   rx = exanic_acquire_rx_buffer(nic, 1, 0);
    if(!rx)
    {
        fprintf(stderr, "exanic_acquire_rx_buffer: %s\n", exanic_get_last_error());
        return 1;
    }

    char packet[2048];
    memset(packet, 0, 2048);

    gfex_t *gfex;

    while(1)
    {
        ssize_t sz = exanic_receive_frame(rx, packet, sizeof(packet), NULL);
        if (sz == sizeof(gfex_t) || sz == sizeof(gfex_t) + 4)
        {
            gfex = (gfex_t *)packet;
            /*
            if (gfex->time == 0x54534542)
                printf("BEST, %s,%.2f\n", gfex->inst_id, gfex->last_px);
	        else if (gfex->time == 0x49425241)
                printf("ARBI, %s,%.2f\n", gfex->inst_id, gfex->last_px);
            */
            printf("time=%u", gfex->flag);
            printf(", inst_id=%s", gfex->inst_id);
            printf(", last_px=%.2f", gfex->last_px);
            printf(", last_match_qty=%d", gfex->last_match_qty);
            printf(", match_total_qty=%d", gfex->match_total_qty);
            printf(", turnover=%.2f", gfex->turnover);
            printf(", open_interest=%.2f", gfex->open_interest);
            printf(", interest_chg=%d", gfex->interest_chg);
            printf(", gen_time=%s", gfex->gen_time);
            printf(", bid_px1=%.2f", gfex->bid_px1);
            printf(", bid_vol1=%d", gfex->bid_vol1);
            printf(", bid_px2=%.2f", gfex->bid_px2);
            printf(", bid_vol2=%d", gfex->bid_vol2);
            printf(", bid_px3=%.2f", gfex->bid_px3);
            printf(", bid_vol3=%d", gfex->bid_vol3);
            printf(", bid_px4=%.2f", gfex->bid_px4);
            printf(", bid_vol4=%d", gfex->bid_vol4);
            printf(", bid_px5=%.2f", gfex->bid_px5);
            printf(", bid_vol5=%d", gfex->bid_vol5);

            printf(", ask_px1=%.2f", gfex->ask_px1);
            printf(", ask_vol1=%d", gfex->ask_vol1);
            printf(", ask_px2=%.2f", gfex->ask_px2);
            printf(", ask_vol2=%d", gfex->ask_vol2);
            printf(", ask_px3=%.2f", gfex->ask_px3);
            printf(", ask_vol3=%d", gfex->ask_vol3);
            printf(", ask_px4=%.2f", gfex->ask_px4);
            printf(", ask_vol4=%d", gfex->ask_vol4);
            printf(", ask_px5=%.2f", gfex->ask_px5);
            printf(", ask_vol5=%d",  gfex->ask_vol5);
            printf("\n");
        }

    }

    return 0;
}
