#!/bin/bash

if [[ -z "${1}" ]];then
    echo "Usage：${0} exanic0/exanic1" && exit 1
fi

CurrDir=$(pwd)
if [[ ! -d "${CurrDir}/fw" ]] || [[ ! -d "${CurrDir}/driver" ]] || [[ ! -d "${CurrDir}/license" ]] || [[ ! -d "${CurrDir}/utils" ]] || [[ ! -d "${CurrDir}/sample-code" ]];then
	echo "It has already been installed. Please clear the scheduled tasks before reinstalling and unzip the installation package to reinstall and deploy" && exit 1
fi

NanoDir="/root/nano_exanic_gfex"
if [[ -d "${NanoDir}" ]];then
	mv ${NanoDir} ${NanoDir}_$(date +'%Y%m%d_%H%M%S')
fi
mkdir ${NanoDir}

# install exanic dev driver
cd ${CurrDir}/driver
tar -xvf exanic-software.tar
cd exanic-software
make && make install && modprobe exanic
if [[ ${?} -ne 0 ]];then
    echo "Failed to install exanic driver. please check the above error info." && exit 1
fi

# check target dev platform
if [[ -f /usr/local/bin/exanic-config ]];then
    EXANIC_DIR=/usr/local/bin
elif [[ -f /usr/bin/exanic-config ]];then
    EXANIC_DIR=/usr/bin
else
    echo "cannot find exanic firmware update utils." && exit 1
fi
export PATH=${PATH}:${EXANIC_DIR}

# update fpga firmware
cd ${CurrDir}/fw
PLATFORM=$($EXANIC_DIR/exanic-config ${1} | grep type | awk '{print $4}')
if [[ "$PLATFORM" == "X10" ]];then
    ${EXANIC_DIR}/exanic-fwupdate -d ${1} *x10*.fw.gz -r
elif [[ "$PLATFORM" == "X25" ]];then
    echo "gfex cannot support ${PLATFORM}." && exit 1
else
	echo "gfex cannot support ${PLATFORM}." && exit 1
fi
${EXANIC_DIR}/exanic-fwupdate -d ${1} -r

cd ${CurrDir}
mv license sample-code utils ${NanoDir}

#license
cd ${NanoDir}/license
cat <<EOF > license.sh
#!/bin/bash
${NanoDir}/license/exanic-fpga-controller -d ${1} -k ${NanoDir}/license/exanic-fpga-controller.key
EOF
chmod +x exanic-fpga-controller license.sh

cd ${NanoDir}/utils
cat <<EOF > initnic.sh
#!/bin/bash
${EXANIC_DIR}/exanic-config ${1}:0 up
${EXANIC_DIR}/exanic-config ${1}:1 up
${EXANIC_DIR}/exanic-config ${1}:0 promisc on
${EXANIC_DIR}/exanic-config ${1}:1 promisc on
${EXANIC_DIR}/exanic-config ${1}:0 bypass-only on
${EXANIC_DIR}/exanic-config ${1}:1 bypass-only on
${EXANIC_DIR}/exanic-config ${1}:0 speed 10000
${EXANIC_DIR}/exanic-config ${1}:1 speed 10000
EOF
chmod +x getgfexkey.sh initnic.sh

cat <<EOF > cron
#nano ${NanoDir} $(date)
@reboot ${NanoDir}/utils/initnic.sh
50-58 8,20 * * 1-5 ${NanoDir}/utils/getgfexkey.sh
* * * * 1-5 ${NanoDir}/license/license.sh
EOF

serverName="crond"
cronDir="/var/spool/cron/root"
source /etc/os-release
if [[ "ubuntu" == ${ID} ]];then
	serverName="cron"
	cronDir="/var/spool/cron/crontabs/root"
	lsb_release -a
fi

if [[ -f ${cronDir} ]];then
	cat cron >> ${cronDir}
else
	crontab cron
fi

cd ${CurrDir}
rm -rf fw driver

chown root.root ${NanoDir} -R
${NanoDir}/utils/initnic.sh
systemctl enable ${serverName}
systemctl start ${serverName}
echo "${serverName} service is $(systemctl is-enabled ${serverName})"

echo "please tell luis the following info."
echo $(exanic-config ${1} | grep "MAC address:" | awk '{print $3}' | head -1)
echo $(ip a | grep inet | awk '{print $2}')
echo "'ssh-keygen' generate pub key, and 'cat ~/.ssh/id_rsa.pub'(119.3.128.227:19900)"
${NanoDir}/utils/getgfexkey.sh
