/*
 * HFP mm core interface.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HFP_MM_USR_H
#define HFP_MM_USR_H

#include <linux/kernel.h>
#include <linux/device.h>
#include <linux/semaphore.h>
#include <linux/cdev.h>
#include <linux/list.h>

#include "enyx_hfp_bus.h"
#include "enyx_hfp_char_device.h"

/**
 *
 */
int
enyx_hfp_mm_class_register(void);

/**
 *
 */
void
enyx_hfp_mm_class_unregister(void);


/**
 *
 */
struct enyx_hfp_mm_usr {
    struct enyx_hfp_device * parent;

    phys_addr_t phys_addr;
    size_t size;
    unsigned int index;

    struct semaphore lock;
    struct cdev cdev;
    struct enyx_hfp_char_device_region * region;
    dev_t dev;

    struct device device;
};

/**
 *
 */
#define to_enyx_hfp_mm_usr(n) \
    container_of(n, struct enyx_hfp_mm_usr, device)

/**
 *
 */
#define create_enyx_hfp_mm_usr(_parent, _region) \
    __create_enyx_hfp_mm_usr(_parent, _region, THIS_MODULE)

struct enyx_hfp_mm_usr *
__create_enyx_hfp_mm_usr(struct enyx_hfp_device * parent,
                    struct enyx_hfp_char_device_region * region,
                    struct module * owner);

/**
 *
 */
void
destroy_enyx_hfp_mm_usr(struct enyx_hfp_mm_usr * bus);

#endif /* HFP_MM_USR_H */

