/*
 * HFP char device region interface.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HFP_CHAR_DEVICE_H
#define HFP_CHAR_DEVICE_H

#include <linux/types.h>

struct enyx_hfp_char_device_region;

struct enyx_hfp_char_device_region *
enyx_hfp_char_device_region_create(const char * name);

void
enyx_hfp_char_device_region_destroy(struct enyx_hfp_char_device_region * region);

dev_t
enyx_hfp_char_device_get(struct enyx_hfp_char_device_region * region);

void
enyx_hfp_char_device_put(struct enyx_hfp_char_device_region * region,
                    const dev_t dev);

#endif // HFP_CHAR_DEVICE_H

