#include <cerrno>

ENYX_HW_NAMESPACE_BEGIN
namespace mocking {

inline
mock::mock() noexcept
{
    mock_.count_accelerators = [] (void * context) -> size_t
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->count_accelerators)
            return 0;
        return thiz->count_accelerators();
    };

    mock_.get_accelerator_uid = [] (void * context,
                                    uint32_t accelerator_index,
                                    char * buffer,
                                    size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_accelerator_uid) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_accelerator_uid(accelerator_index, buffer, capacity);
    };

    mock_.get_accelerator_name = [] (void * context,
                                     uint32_t accelerator_index,
                                     char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_accelerator_name) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_accelerator_name(accelerator_index, buffer, capacity);
    };

    mock_.count_mmios = [] (void * context,
                            uint32_t accelerator_index) -> size_t
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->count_mmios)
            return 0;
        return thiz->count_mmios(accelerator_index);
    };

    mock_.get_mmio_size = [] (void * context,
                              uint32_t accelerator_index, uint32_t mmio_index,
                              size_t * size) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_mmio_size) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_mmio_size(accelerator_index, mmio_index, size);
    };

    mock_.get_mmio_uid = [] (void * context,
                             uint32_t accelerator_index, uint32_t mmio_index,
                             char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_mmio_uid) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_mmio_uid(accelerator_index, mmio_index, buffer,
                                  capacity);
    };

    mock_.get_mmio_name = [] (void * context,
                              uint32_t accelerator_index, uint32_t mmio_index,
                              char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_mmio_name) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_mmio_name(accelerator_index, mmio_index, buffer,
                                   capacity);
    };

    mock_.mmio_write_8 = [] (void * context,
                             uint32_t accelerator_index, uint32_t mmio_index,
                             uint64_t addr, uint8_t value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_write_8) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_write_8(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_write_16 = [] (void * context,
                              uint32_t accelerator_index, uint32_t mmio_index,
                              uint64_t addr, uint16_t value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_write_16) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_write_16(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_write_32 = [] (void * context,
                              uint32_t accelerator_index, uint32_t mmio_index,
                              uint64_t addr, uint32_t value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_write_32) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_write_32(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_write_64 = [] (void * context,
                              uint32_t accelerator_index, uint32_t mmio_index,
                              uint64_t addr, uint64_t value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_write_64) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_write_64(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_read_8 = [] (void * context,
                            uint32_t accelerator_index, uint32_t mmio_index,
                            uint64_t addr, uint8_t * value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_read_8) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_read_8(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_read_16 = [] (void * context,
                             uint32_t accelerator_index, uint32_t mmio_index,
                             uint64_t addr, uint16_t * value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_read_16) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_read_16(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_read_32 = [] (void * context,
                             uint32_t accelerator_index, uint32_t mmio_index,
                             uint64_t addr, uint32_t * value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_read_32) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_read_32(accelerator_index, mmio_index, addr, value);
    };

    mock_.mmio_read_64 = [] (void * context,
                             uint32_t accelerator_index, uint32_t mmio_index,
                             uint64_t addr, uint64_t * value) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->mmio_read_64) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->mmio_read_64(accelerator_index, mmio_index, addr, value);
    };

    mock_.count_c2a_streams = [] (void * context,
                                  uint32_t accelerator_index) -> size_t
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->count_c2a_streams)
            return 0;
        return thiz->count_c2a_streams(accelerator_index);
    };

    mock_.on_c2a_stream_create = [] (void * context,
                                     uint32_t accelerator_index,
                                     uint32_t stream_index) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->on_c2a_stream_create)
            return 0;
        return thiz->on_c2a_stream_create(accelerator_index, stream_index);

    };

    mock_.on_c2a_stream_destroy = [] (void * context,
                                      uint32_t accelerator_index,
                                      uint32_t stream_index) -> void
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->on_c2a_stream_destroy)
            return;
        thiz->on_c2a_stream_destroy(accelerator_index, stream_index);

    };

    mock_.get_c2a_stream_uid = [] (void * context,
                                   uint32_t accelerator_index,
                                   uint32_t stream_index,
                                   char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_c2a_stream_uid) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_c2a_stream_uid(accelerator_index, stream_index,
                                        buffer, capacity);
    };

    mock_.get_c2a_stream_name = [] (void * context,
                                    uint32_t accelerator_index,
                                    uint32_t stream_index,
                                    char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_c2a_stream_name) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_c2a_stream_name(accelerator_index, stream_index,
                                         buffer, capacity);
    };

    mock_.get_c2a_stream_mtu = [] (void * context,
                                   uint32_t accelerator_index,
                                   uint32_t stream_index,
                                   uint32_t *mtu) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_c2a_stream_mtu) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_c2a_stream_mtu(accelerator_index, stream_index, mtu);
    };

    mock_.get_c2a_stream_size = [] (void * context,
                                    uint32_t accelerator_index,
                                    uint32_t stream_index,
                                    size_t *size) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_c2a_stream_size) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_c2a_stream_size(accelerator_index, stream_index,
                                         size);
    };

    mock_.c2a_stream_send = [] (void * context,
                                uint32_t accelerator_index,
                                uint32_t stream_index,
                                void const *data,
                                uint32_t size) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->c2a_stream_send) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->c2a_stream_send(accelerator_index, stream_index, data,
                                     size);
    };

    mock_.c2a_stream_send_io_vec = [] (void * context,
                                       uint32_t accelerator_index,
                                       uint32_t stream_index,
                                       enyx_hw_c2a_stream_io_vec const *vectors,
                                       uint32_t vectors_count) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->c2a_stream_send_io_vec) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->c2a_stream_send_io_vec(accelerator_index, stream_index,
                                            vectors, vectors_count);
    };

    mock_.is_c2a_stream_ready = [] (void * context,
                                    uint32_t accelerator_index,
                                    uint32_t stream_index) -> bool
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->is_c2a_stream_ready) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->is_c2a_stream_ready(accelerator_index, stream_index);
    };

    mock_.is_c2a_stream_idle = [] (void * context,
                                   uint32_t accelerator_index,
                                   uint32_t stream_index) -> bool
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->is_c2a_stream_idle) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->is_c2a_stream_idle(accelerator_index, stream_index);
    };

    mock_.wait_until_c2a_stream_is_idle = [] (void * context,
                                              uint32_t accelerator_index,
                                              uint32_t stream_index,
                                              uint32_t us_timeout) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->wait_until_c2a_stream_is_idle) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->wait_until_c2a_stream_is_idle(accelerator_index,
                                                   stream_index, us_timeout);
    };

    mock_.count_a2c_streams = [] (void * context,
                                  uint32_t accelerator_index) -> size_t
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->count_a2c_streams)
            return 0;
        return thiz->count_a2c_streams(accelerator_index);
    };

    mock_.on_a2c_stream_create = [] (void * context,
                                     uint32_t accelerator_index,
                                     uint32_t stream_index) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->on_a2c_stream_create)
            return 0;
        return thiz->on_a2c_stream_create(accelerator_index, stream_index);

    };

    mock_.on_a2c_stream_destroy = [] (void * context,
                                      uint32_t accelerator_index,
                                      uint32_t stream_index) -> void
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->on_a2c_stream_destroy)
            return;
        thiz->on_a2c_stream_destroy(accelerator_index, stream_index);

    };

    mock_.get_a2c_stream_uid = [] (void * context,
                                   uint32_t accelerator_index,
                                   uint32_t stream_index,
                                   char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_uid) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_uid(accelerator_index, stream_index,
                                        buffer, capacity);
    };

    mock_.get_a2c_stream_name = [] (void * context,
                                    uint32_t accelerator_index,
                                    uint32_t stream_index,
                                    char * buffer, size_t capacity) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_name) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_name(accelerator_index, stream_index,
                                         buffer, capacity);
    };

    mock_.get_a2c_stream_mtu = [] (void * context,
                                   uint32_t accelerator_index,
                                   uint32_t stream_index,
                                   uint32_t *mtu) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_mtu) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_mtu(accelerator_index, stream_index, mtu);
    };

    mock_.get_a2c_stream_size = [] (void * context,
                                    uint32_t accelerator_index,
                                    uint32_t stream_index,
                                    size_t *size) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_size) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_size(accelerator_index, stream_index,
                                         size);
    };

    mock_.poll_a2c_stream_once = [] (void * context,
                                     uint32_t accelerator_index,
                                     uint32_t stream_index,
                                     enyx_hw_a2c_stream_handler on_data,
                                     void * opaque) -> size_t
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->poll_a2c_stream_once) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->poll_a2c_stream_once(accelerator_index, stream_index,
                                          on_data, opaque);
    };

    mock_.get_a2c_stream_packet_count = [] (void * context,
                                            uint32_t accelerator_index,
                                            uint32_t stream_index,
                                            uint32_t * packet_count) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_packet_count) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_packet_count(accelerator_index,
                                                 stream_index, packet_count);
    };

    mock_.get_a2c_stream_backpressure = [] (void * context,
                                            uint32_t accelerator_index,
                                            uint32_t stream_index,
                                            uint32_t * backpressure) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_backpressure) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_backpressure(accelerator_index,
                                                 stream_index, backpressure);
    };

    mock_.get_a2c_stream_fifo_errors = [] (void * context,
                                           uint32_t accelerator_index,
                                           uint32_t stream_index,
                                           uint32_t * fifo_errors) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_fifo_errors) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_fifo_errors(accelerator_index,
                                                stream_index, fifo_errors);
    };

    mock_.get_a2c_stream_truncated_count = [] (void * context,
                                               uint32_t accelerator_index,
                                               uint32_t stream_index,
                                               uint32_t * truncated_count) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_truncated_count) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_truncated_count(accelerator_index, stream_index,
                                           truncated_count);
    };

    mock_.get_a2c_stream_errors = [] (void * context,
                                      uint32_t accelerator_index,
                                      uint32_t stream_index,
                                      uint32_t * errors) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_errors) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_errors(accelerator_index, stream_index,
                                           errors);
    };

    mock_.get_a2c_stream_usage = [] (void * context,
                                     uint32_t accelerator_index,
                                     uint32_t stream_index,
                                     uint32_t * usage) -> int
    {
        mock * thiz = reinterpret_cast<mock *>(context);
        if (! thiz->get_a2c_stream_usage) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_a2c_stream_usage(accelerator_index, stream_index,
                                          usage);
    };

    mock_.context = this;
}

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
inline
mock::mock(mock && other)
    :
        count_accelerators(other.count_accelerators),
        get_accelerator_uid(other.get_accelerator_uid),
        get_accelerator_name(other.get_accelerator_name),
        count_mmios(other.count_mmios),
        get_mmio_size(other.get_mmio_size),
        get_mmio_uid(other.get_mmio_uid),
        get_mmio_name(other.get_mmio_name),
        mmio_write_8(other.mmio_write_8),
        mmio_write_16(other.mmio_write_16),
        mmio_write_32(other.mmio_write_32),
        mmio_write_64(other.mmio_write_64),
        mmio_read_8(other.mmio_read_8),
        mmio_read_16(other.mmio_read_16),
        mmio_read_32(other.mmio_read_32),
        mmio_read_64(other.mmio_read_64),
        count_c2a_streams(other.count_c2a_streams),
        get_c2a_stream_uid(other.get_c2a_stream_uid),
        get_c2a_stream_name(other.get_c2a_stream_name),
        get_c2a_stream_mtu(other.get_c2a_stream_mtu),
        get_c2a_stream_size(other.get_c2a_stream_size),
        c2a_stream_send(other.c2a_stream_send),
        c2a_stream_send_io_vec(other.c2a_stream_send_io_vec),
        is_c2a_stream_ready(other.is_c2a_stream_ready),
        is_c2a_stream_idle(other.is_c2a_stream_idle),
        wait_until_c2a_stream_is_idle(other.wait_until_c2a_stream_is_idle),
        count_a2c_streams(other.count_a2c_streams),
        get_a2c_stream_uid(other.get_a2c_stream_uid),
        get_a2c_stream_name(other.get_a2c_stream_name),
        get_a2c_stream_mtu(other.get_a2c_stream_mtu),
        get_a2c_stream_size(other.get_a2c_stream_size),
        poll_a2c_stream_once(other.poll_a2c_stream_once),
        get_a2c_stream_packet_count(other.get_a2c_stream_packet_count),
        get_a2c_stream_backpressure(other.get_a2c_stream_backpressure),
        get_a2c_stream_fifo_errors(other.get_a2c_stream_fifo_errors),
        get_a2c_stream_errors(other.get_a2c_stream_errors),
        get_a2c_stream_usage(other.get_a2c_stream_usage),
        mock_(other.mock_)
{
    mock_.context = this;
}

inline
mock& mock::operator=(mock && other)
{
    count_accelerators = other.count_accelerators;
    get_accelerator_uid = other.get_accelerator_uid;
    get_accelerator_name = other.get_accelerator_name;
    count_mmios = other.count_mmios;
    get_mmio_size = other.get_mmio_size;
    get_mmio_uid = other.get_mmio_uid;
    get_mmio_name = other.get_mmio_name;
    mmio_write_8 = other.mmio_write_8;
    mmio_write_16 = other.mmio_write_16;
    mmio_write_32 = other.mmio_write_32;
    mmio_write_64 = other.mmio_write_64;
    mmio_read_8 = other.mmio_read_8;
    mmio_read_16 = other.mmio_read_16;
    mmio_read_32 = other.mmio_read_32;
    mmio_read_64 = other.mmio_read_64;
    count_c2a_streams = other.count_c2a_streams;
    get_c2a_stream_uid = other.get_c2a_stream_uid;
    get_c2a_stream_name = other.get_c2a_stream_name;
    get_c2a_stream_mtu = other.get_c2a_stream_mtu;
    get_c2a_stream_size = other.get_c2a_stream_size;
    c2a_stream_send = other.c2a_stream_send;
    c2a_stream_send_io_vec = other.c2a_stream_send_io_vec;
    is_c2a_stream_ready = other.is_c2a_stream_ready;
    is_c2a_stream_idle = other.is_c2a_stream_idle;
    wait_until_c2a_stream_is_idle = other.wait_until_c2a_stream_is_idle;
    count_a2c_streams = other.count_a2c_streams;
    get_a2c_stream_uid = other.get_a2c_stream_uid;
    get_a2c_stream_name = other.get_a2c_stream_name;
    get_a2c_stream_mtu = other.get_a2c_stream_mtu;
    get_a2c_stream_size = other.get_a2c_stream_size;
    poll_a2c_stream_once = other.poll_a2c_stream_once;
    get_a2c_stream_packet_count = other.get_a2c_stream_packet_count;
    get_a2c_stream_backpressure = other.get_a2c_stream_backpressure;
    get_a2c_stream_fifo_errors = other.get_a2c_stream_fifo_errors;
    get_a2c_stream_errors = other.get_a2c_stream_errors;
    get_a2c_stream_usage = other.get_a2c_stream_usage;
    mock_ = other.mock_;
    mock_.context = this;
    return *this;
}
#pragma GCC diagnostic pop

inline
enyx_hw_mock const &
mock::handle() const noexcept
{
    return mock_;
}

inline
enyx_hw_mock &
mock::handle() noexcept
{
    return mock_;
}

} /* namespace mocking */
ENYX_HW_NAMESPACE_END
