ENYX_HW_NAMESPACE_BEGIN
namespace mocking {

inline
accelerator::accelerator(::enyx_hw_mock * mock)
    : mock_(mock)
    , handle_(::enyx_hwm_accelerator_create(mock_))
    , mmios_()
    , a2c_streams_()
    , c2a_streams_()
{
}

inline
accelerator::accelerator(::enyx_hw_mock & mock)
    : accelerator(&mock)
{
}

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
inline
accelerator::accelerator(mock & mock)
    : accelerator(mock.handle())
{
}
#pragma GCC diagnostic pop

inline
accelerator::~accelerator()
{
}

inline result<void>
accelerator::set_version(product_version const & version) noexcept
{
    if (::enyx_hwm_accelerator_set_version(handle(), &version) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
accelerator::set_name(std::string const & name) noexcept
{
    if (::enyx_hwm_accelerator_set_name(handle(), name.c_str()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
accelerator::set_user_count(size_t count) noexcept
{
    if (::enyx_hwm_accelerator_set_user_count(handle(), count) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
accelerator::set_reset_callback(reset_cb_t && cb) noexcept
{
    enyx_hwm_accelerator_reset_cb_t c_cb = [] (void * context) {
        reset_cb_t * cpp_cb = reinterpret_cast<reset_cb_t *>(context);
        (*cpp_cb)();
    };

    if (::enyx_hwm_accelerator_set_reset_callback(handle(), c_cb, &cb) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

template<typename A2CStream, typename... Args>
inline A2CStream &
accelerator::add_a2c_stream(Args&&... args)
{
    std::unique_ptr<A2CStream> ptr{new A2CStream{args...}};
    A2CStream & ret = *ptr;
    if (::enyx_hwm_accelerator_bind_a2c_stream(handle(), ret.handle()) < 0)
        throw std::system_error{errno, std::generic_category(),
                                "Could not add a2c_stream to accelerator"};
    a2c_streams_.emplace_back(std::move(ptr));

    return ret;
}

template<typename C2AStream, typename... Args>
inline C2AStream &
accelerator::add_c2a_stream(Args&&... args)
{
    std::unique_ptr<C2AStream> ptr{new C2AStream{args...}};
    C2AStream & ret = *ptr;
    if (::enyx_hwm_accelerator_bind_c2a_stream(handle(), ret.handle()) < 0)
        throw std::system_error{errno, std::generic_category(),
                                "Could not add c2a_stream to accelerator"};
    c2a_streams_.emplace_back(std::move(ptr));

    return ret;
}

template<typename MMIO, typename... Args>
inline MMIO &
accelerator::add_mmio(Args&&... args)
{
    std::unique_ptr<MMIO> ptr{new MMIO{args...}};
    MMIO & ret = *ptr;
    if (::enyx_hwm_accelerator_bind_mmio(handle(), ret.handle()) < 0)
        throw std::system_error{errno, std::generic_category(),
                                "Could not add mmio to accelerator"};
    mmios_.emplace_back(std::move(ptr));

    return ret;
}

inline ::enyx_hwm_accelerator *
accelerator::handle() noexcept
{
    return handle_.get();
}

inline ::enyx_hwm_accelerator const *
accelerator::handle() const noexcept
{
    return handle_.get();
}

} /* namespace mocking */
ENYX_HW_NAMESPACE_END
