/**
 *  @file
 *
 *  Contains the legacy mocking interfaces.
 *
 *  Also includes all the mocking headers.
 */
#pragma once

#include <cstdint>

#include <enyx/hw_c/mock.h>

#include <enyx/hw/macros.hpp>
#include <enyx/hw/namespace.hpp>

#include <enyx/hw/mocking/accelerator.hpp>
#include <enyx/hw/mocking/a2c_stream.hpp>
#include <enyx/hw/mocking/c2a_stream.hpp>
#include <enyx/hw/mocking/installer.hpp>
#include <enyx/hw/mocking/mmio.hpp>
#include <enyx/hw/mocking/mock.hpp>

ENYX_HW_NAMESPACE_BEGIN

/// @cond
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
using mock ENYX_HW_CXX_DEPRECATED("Replaced by mocking::mock") = mocking::mock;
#pragma GCC diagnostic pop
using mock_installer ENYX_HW_CXX_DEPRECATED("Replaced by mocking::installer") = mocking::installer;
using mocked_register ENYX_HW_CXX_DEPRECATED("Replaced by mocking::mocked_register") = mocking::mocked_register;
using mocked_core ENYX_HW_CXX_DEPRECATED("Replaced by mocking::core") = mocking::core;


/**
 *  This class is used to bind the mock mmio callbacks
 *  to an instantiated mocked_core tree
 */
class ENYX_HW_CXX_DEPRECATED("Use the mocking::mmio class instead") mocked_mmio : public mocking::mmio
{
public:
    /**
     * Patch the @p mock to register mmio methods
     * that redirect access to @p root
     *
     * @param mock The mock to patch
     * @param root The root core to use
     * @param width The mmio address width used
     *
     * @warning Deprectated: Use mocking::mmio instead.
     */
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
    mocked_mmio(mocking::mock & mock,
                mocking::mocked_core & root,
                std::uint8_t width = 32);
#pragma GCC diagnostic pop

    /**
     * Unregister mmio methods
     */
    ~mocked_mmio();

private:
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
    mocking::mock & mock_;
#pragma GCC diagnostic pop
};
/// @endcond

ENYX_HW_NAMESPACE_END

#include <enyx/hw/mock.ipp>
