/**
 *  @file
 *
 *  This file contains the enum and functions related to the
 *  library error handling.
 */
#pragma once

#include <system_error>
#include <exception>

#include <enyx/hw/namespace.hpp>

ENYX_HW_NAMESPACE_BEGIN

/// The hw specific error codes
enum errc {
    /**
     *  The feature is not yet implemented
     *  @since 1.0.0
     */
    UNIMPLEMENTED = 1,
};

/**
 *  Get the hw specific std::error_category class
 *
 *  @note This function is not called directly,
 *        make_error_code(errc c) is preferred.
 *
 *  @return A reference to the std::error_category
 *  @since 1.0.0
 */
std::error_category const&
category() noexcept;

/**
 *  Create an std::error_code from a hw error @p e
 *
 *  @param e The error code
 *  @return An error_code bound to the provided @p e
 *  @since 1.0.0
 */
std::error_code
make_error_code(errc e);

ENYX_HW_NAMESPACE_END

/// @cond
namespace std {

template<>
struct is_error_code_enum<enyx::hw::errc> : std::true_type
{ };

}
/// @endcond

#include <enyx/hw/error.ipp>
