ENYX_HW_NAMESPACE_BEGIN

inline
c2a_stream::c2a_stream(c2a_stream_descriptor const & descriptor)
    : accelerator_(descriptor.get_accelerator()),
      c2a_stream_(enyx_hw_c2a_stream_create(descriptor.handle(), nullptr),
                  &enyx_hw_c2a_stream_destroy)
{
    if (c2a_stream_ == nullptr)
        throw std::system_error(errno, std::generic_category());
}

inline
c2a_stream::c2a_stream(c2a_stream_descriptor const & descriptor,
                       c2a_stream_configuration const &configuration)
    : accelerator_(descriptor.get_accelerator()),
      c2a_stream_(enyx_hw_c2a_stream_create(descriptor.handle(), &configuration),
                  &enyx_hw_c2a_stream_destroy)
{
    if (c2a_stream_ == nullptr)
        throw std::system_error(errno, std::generic_category());
}

inline c2a_stream_descriptor
c2a_stream::get_descriptor() const
{
    return {accelerator_, enyx_hw_c2a_stream_get_descriptor(handle())};
}

inline result<std::uint32_t>
c2a_stream::get_mtu() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_c2a_stream_get_mtu(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::size_t>
c2a_stream::get_size() const noexcept
{
    std::size_t ret;
    if (enyx_hw_c2a_stream_get_size(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<void>
c2a_stream::send(void const * data_ptr, std::uint32_t size) noexcept
{
    if (enyx_hw_c2a_stream_send(handle(), data_ptr, size) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<void>
c2a_stream::send(void const * data_ptr, std::uint32_t size,
                 c2a_stream::flags_t flags) noexcept
{
    if (enyx_hw_c2a_stream_send2(handle(), data_ptr, size, flags) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<void>
c2a_stream::send(iovec const * vectors, std::uint32_t vector_count) noexcept
{
    if (enyx_hw_c2a_stream_send_io_vec(handle(), vectors, vector_count) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<void>
c2a_stream::send(iovec const * vectors, std::uint32_t vector_count, flags_t flags) noexcept
{
    if (enyx_hw_c2a_stream_send_io_vec2(handle(), vectors, vector_count, flags) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline bool
c2a_stream::is_ready() const noexcept
{
    return enyx_hw_c2a_stream_is_ready(handle());
}

inline bool
c2a_stream::is_idle() const noexcept
{
    return enyx_hw_c2a_stream_is_idle(handle());
}

inline result<void>
c2a_stream::wait_until_idle(std::chrono::microseconds timeout) const noexcept
{
    if (enyx_hw_c2a_stream_wait_until_idle(handle(), timeout.count()) != 0)
        return {std::error_code{errno, std::generic_category()}};

    return {};
}

inline enyx_hw_c2a_stream *
c2a_stream::handle() noexcept
{
    return c2a_stream_.get();
}

inline enyx_hw_c2a_stream const *
c2a_stream::handle() const noexcept
{
    return c2a_stream_.get();
}

ENYX_HW_NAMESPACE_END
