#pragma once

#include <enyx/hw/c2a_stream.hpp>

#include <enyx/cores/data_stream/sink.hpp>
#include <enyx/cores/namespace.hpp>
#include <enyx/cores/udp/data_stream.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class UdpSink
{
public:
    UdpSink(hw::c2a_stream && data_out_stream);

    int
    send(std::uint32_t session_id,
         void const * data,
         std::uint32_t size) noexcept;

private:
    hw::c2a_stream stream_;
    data_stream::sink raw_sink_;
    data_stream::sink udp_sink_;
};

inline int
UdpSink::send(std::uint32_t session_id,
              void const * data,
              std::uint32_t size) noexcept
{
    udp::sink_metadata metadata{};
    metadata.session_id = session_id;

    return udp_sink_.send(data, size, &metadata);
}

ENYX_CORES_NAMESPACE_END
