#pragma once

#include <enyx/hw/a2c_stream.hpp>

#include <enyx/cores/data_stream/hw_source.hpp>
#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class TcpEventSource
{
public:
    template<typename Handler>
    TcpEventSource(hw::a2c_stream && stream, Handler && handler)
    : stream_(std::move(stream))
    , raw_source_(data_stream::hw_source(stream_,
                                     std::forward<Handler>(handler)))
    { }

    int
    poll_once()
    {
        return raw_source_.poll_once().value();
    }

private:
    hw::a2c_stream stream_;
    data_stream::hw_source raw_source_;
};

ENYX_CORES_NAMESPACE_END
