#include <iostream>
#include <sstream>
#include <iomanip>
#include <string>
#include <algorithm>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

template<typename Type>
inline std::istream &
operator>>(std::istream & in, Ranges<Type> & ranges)
{
    std::istream::sentry sentry{in};

    if (sentry)
    {
        ranges.clear();
        for (std::string token; std::getline(in, token, ','); )
        {
            Range<Type> range;
            std::istringstream{token} >> range;
            ranges.push_back(range);
        }
    }

    return in;
}

template<typename Type>
inline std::ostream &
operator<<(std::ostream & out, const Ranges<Type> & ranges)
{
    std::ostream::sentry sentry{out};

    if (sentry)
    {
        bool first = true;
        for (auto const& range : ranges)
        {
            if (first)
            {
                out << ", ";
                first = false;
            }

            out << range;
        }
    }

    return out;
}

template<typename Type>
inline std::vector<Type>
as_sequence(const Ranges<Type> & ranges)
{
    std::vector<Type> sequence;
    for (auto const& range : ranges)
    {
        auto const partial_sequence = as_sequence(range);
        sequence.insert(sequence.end(),
                        partial_sequence.begin(),
                        partial_sequence.end());
    }

    // Remove duplicate
    sequence.erase(std::unique(sequence.begin(), sequence.end()),
                   sequence.end());

    return sequence;
}

ENYX_CORES_NAMESPACE_END
