#include "BandwidthThrottle.hpp"

ENYX_CORES_NAMESPACE_BEGIN

void
BandwidthThrottle::reset(std::size_t bytes_per_s)
{
    bytes_per_s_ = bytes_per_s;
    begin_ = Clock::now();
}

std::size_t
BandwidthThrottle::theoretical_sent_bytes() const
{
    auto const elapsed = Clock::now() - begin_;
    static_assert(Clock::period::num == 1, "clock period is sub-second");
    return elapsed.count() * bytes_per_s_ / Clock::period::den;
}

ENYX_CORES_NAMESPACE_END
