ENYX_CORES_NAMESPACE_BEGIN
namespace tcp {

inline
session_monitor::session_monitor(tcp const & tcp)
    : monitor_(::enyx_tcp_session_monitor_create(tcp.handle()))
{
    if (monitor_ == nullptr)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create session_monitor"};
}

inline result<void>
session_monitor::add_session(session const & session) noexcept
{
    if (::enyx_tcp_session_monitor_add_session(handle(), session.handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
session_monitor::remove_session(session const & session) noexcept
{
    if (::enyx_tcp_session_monitor_remove_session(handle(), session.handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline size_t
session_monitor::count() const noexcept
{
    return ::enyx_tcp_session_monitor_count(handle());
}

inline result<std::vector<session_monitor::event>>
session_monitor::poll_events() const noexcept
{
    std::vector<session_monitor::event> output(count());
    if (output.size() == 0)
        return {};
    auto ret = ::enyx_tcp_session_monitor_poll_events(handle(),
                                                      output.data(),
                                                      output.size());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    output.resize(ret);

    return output;
}

inline ::enyx_tcp_session_monitor *
session_monitor::handle() const noexcept
{
    return monitor_.get();
}

} /* namespace tcp */
ENYX_CORES_NAMESPACE_END
