ENYX_CORES_NAMESPACE_BEGIN
namespace icmp {

inline
icmp::icmp(enyx::hw::core const& icmp_core)
    : icmp_core_(icmp_core),
      handle_(::enyx_icmp_create(icmp_core_.handle()))

{
    if (! handle_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create ICMP"};
}

inline enyx::hw::core
icmp::get_core() const noexcept
{
    return icmp_core_;
}

inline bool
icmp::enabled() const noexcept
{
    return ::enyx_icmp_enabled(handle());
}

inline result<void>
icmp::enable() noexcept
{
    if (::enyx_icmp_enable(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
icmp::disable() noexcept
{
    if (::enyx_icmp_disable(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline ::enyx_icmp const *
icmp::handle() const noexcept
{
    return handle_.get();
}

inline ::enyx_icmp *
icmp::handle() noexcept
{
    return handle_.get();
}

} /* namespace icmp */
ENYX_CORES_NAMESPACE_END
