#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

namespace data_stream {

inline
source::source()
    : c_source_()
{ }

inline
source::source(::enyx_data_stream_source const& c_source)
    : c_source_(c_source)
{ }

inline ::enyx_data_stream_source const *
source::handle() const noexcept
{
    return &c_source_;
}

inline ::enyx_data_stream_source *
source::handle() noexcept
{
    return &c_source_;
}

template<typename Callable>
inline
functor_source<Callable>::functor_source(Callable&& callable)
    : source()
    , callable_(std::forward<Callable>(callable))
{
    handle()->on_data = on_data;
    handle()->opaque = this;
}

template<typename Callable>
inline void
functor_source<Callable>::on_data(std::uint8_t const * data,
                                  std::uint32_t size,
                                  void const * metadata,
                                  void * opaque)
{
    auto source = reinterpret_cast<functor_source*>(opaque);
    source->callable_(data, size, metadata);
}

template<typename Handler>
inline source_ptr
// Relying on expression SFINAE here. This function will be available only
// if method Handler::as_next_source() exists.
make_source(Handler && handler, decltype(handler.as_next_source(), int()))
{
    using type = source;
    return source_ptr{new type{handler.as_next_source()}};
}

template<typename Handler>
inline source_ptr
make_source(Handler && handler, long)
{
    using type = functor_source<Handler>;
    return source_ptr{new type{std::forward<Handler>(handler)}};
}

template<typename Handler>
inline source_ptr
make_source(Handler && handler)
{
    // If the first method is available, it will be prefered due to
    // the `int{}` argument that matches its signature.
    // Else the second method will be picked and the integer argument
    // will be promoted to `long`.
    // Basic SFINAE tricks.
    return make_source(std::forward<Handler>(handler), int{});
}

} /* namespace data_stream */

ENYX_CORES_NAMESPACE_END
