ENYX_CORES_NAMESPACE_BEGIN

namespace data_stream {

inline
sink::sink(::enyx_data_stream_sink const& sink) noexcept
    : sink_(new ::enyx_data_stream_sink(sink))
{ }

inline int
sink::send(buffer const * buffer,
           void const* metadata) noexcept
{
    return ::enyx_data_stream_sink_send_io_vec(handle(), buffer, metadata);
}

inline int
sink::send(void const * data,
           std::uint32_t size,
           void const* metadata) noexcept
{
    return ::enyx_data_stream_sink_send(handle(), data, size, metadata);
}

inline result<size_t>
sink::get_mtu() const noexcept
{
    auto result = ::enyx_data_stream_sink_get_mtu(handle());
    if (result == -1)
        return std::error_code{errno, std::generic_category()};
    return result;
}

inline ::enyx_data_stream_sink *
sink::handle() const noexcept
{
    return sink_.get();
}

} // namespace data_stream

ENYX_CORES_NAMESPACE_END
