#pragma once

#include <utility>
#include <enyx/hw/a2c_stream.hpp>

#include <enyx/cores/namespace.hpp>
#include <enyx/cores/data_stream/hw_source.hpp>
#include <enyx/cores/udp/data_stream.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class UdpSource
{
public:
    UdpSource(hw::a2c_stream && data_in_stream);

    template<typename OnData>
    int
    poll_once(OnData && on_data);

private:
    hw::a2c_stream stream_;
};

template<typename OnData>
inline int
UdpSource::poll_once(OnData && on_data)
{
    auto on_data_wrapper = [&](std::uint8_t const * data,
                               std::uint32_t size,
                               void const * metadata)
    {
        using metadata_t = udp::source_metadata const*;
        on_data(reinterpret_cast<metadata_t>(metadata)->session_id,
                reinterpret_cast<metadata_t>(metadata)->remote_ip,
                reinterpret_cast<metadata_t>(metadata)->remote_port,
                data, size);
    };

    auto source = udp::source(on_data_wrapper);
    auto raw_source = data_stream::hw_source(stream_, source);

    return raw_source.poll_once().value();
}

ENYX_CORES_NAMESPACE_END
