#pragma once

#include <stdint.h>
#include <iosfwd>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class Size
{
public:
    enum UnitSystem { SI, IEC };

public:
    constexpr
    Size(uint64_t value = 0ULL,
         UnitSystem unit_system = IEC)
        : value_(value),
          unit_system_(unit_system)
    { }

    operator const uint64_t &() const
    { return value_; }

    operator uint64_t &()
    { return value_; }

    UnitSystem
    get_unit_system() const
    { return unit_system_; }

private:
    uint64_t value_;
    UnitSystem unit_system_;
};

std::istream &
operator>>(std::istream & in, Size & size);

std::ostream &
operator<<(std::ostream & out, const Size & size);

ENYX_CORES_NAMESPACE_END
