#include "DataValidation.hpp"

ENYX_CORES_NAMESPACE_BEGIN

bool
is_rx_data_valid(SessionConfiguration const & configuration,
                 std::size_t expected_data,
                 std::uint8_t const * data,
                 std::uint32_t size)
{
    // Each byte is expected to be equal to its offset within
    // the data stream modulo 8 bits.
    // The offset within the data stream is computed from
    // session.received_bytes which is the offset of the last byte
    // from the previous TCP segment + the offset within the
    // current TCP segment.
    switch (configuration.verify)
    {
    case SessionConfiguration::ALL:
        for (auto i = 0ULL; i != size; ++i)
            if (data[i] != std::uint8_t(expected_data + i))
                return false;
        break;

    case SessionConfiguration::FIRST:
        if (*data != std::uint8_t(expected_data))
            return false;
        break;

    default:
        break;
    }

    return true;
}

ENYX_CORES_NAMESPACE_END
