#pragma once

#include <enyx/cores/namespace.hpp>

#include "Cpu.hpp"
#include "SessionConfiguration.hpp"

ENYX_CORES_NAMESPACE_BEGIN

struct ApplicationConfiguration
{
    enum Mode { RX, TX, BOTH, LOOPBACK };
    enum Protocol { UDP, TCP };

    Mode mode;
    Protocol protocol;
    CpuCoreIdRanges cpu_core_ids;
    SessionConfigurations session_configurations;
    std::string accelerator;
    std::uint32_t stack_index;
    bool safe_mode;
};

std::istream &
operator>>(std::istream & in, ApplicationConfiguration::Protocol & protocol);

std::ostream &
operator<<(std::ostream & out, const ApplicationConfiguration::Protocol & protocol);

std::istream &
operator>>(std::istream & in, ApplicationConfiguration::Mode & mode);

std::ostream &
operator<<(std::ostream & out, const ApplicationConfiguration::Mode & mode);

std::ostream &
operator<<(std::ostream & out, const ApplicationConfiguration & configuration);

ENYX_CORES_NAMESPACE_END
