#include "SessionConfiguration.hpp"

#include <stdexcept>
#include <iostream>
#include <sstream>

#include <boost/date_time/posix_time/posix_time.hpp>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

std::istream &
operator>>(std::istream & in, SessionConfiguration::Type & type)
{
    std::istream::sentry sentry(in);

    if (sentry)
    {
        std::string s;
        in >> s;

        if (s == "client")
            type = SessionConfiguration::CLIENT;
        else if (s == "server")
            type = SessionConfiguration::SERVER;
        else
        {
            std::ostringstream error;
            error << "Unexpected type (" << s << ")";
            throw std::runtime_error(error.str());
        }
    }

    return in;
}

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration::Type & type)
{
    std::ostream::sentry sentry(out);

    if (! sentry)
        return out;

    switch (type)
    {
    default:
    case SessionConfiguration::CLIENT:
        return out << "client";
    case SessionConfiguration::SERVER:
        return out << "server";
    }
}

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration & configuration)
{
    std::ostream::sentry sentry(out);

    if (sentry)
    {
        out << "interface_id: " << configuration.interface_id << "\n";
        out << "type: " << configuration.type << "\n";
        out << std::flush;
    }

    return out;
}

ENYX_CORES_NAMESPACE_END
