#include "ApplicationConfiguration.hpp"

#include <iostream>
#include <sstream>
#include <stdexcept>
#include <utility>

ENYX_CORES_NAMESPACE_BEGIN

std::ostream &
operator<<(std::ostream & out, const ApplicationConfiguration & configuration)
{
    std::ostream::sentry sentry(out);

    if (sentry)
    {
        out << "accelerator" << configuration.accelerator << "\n";
        out << "stack_index" << int(configuration.stack_index) << "\n";
        for (auto const& c : configuration.session_configurations)
            out << "---" << "\n" << c;
        out << std::flush;
    }

    return out;
}

ENYX_CORES_NAMESPACE_END
