#include <enyx/cores/namespace.hpp>
#include <sstream>
#include <pthread.h>
#include <stdexcept>
ENYX_CORES_NAMESPACE_BEGIN

inline void
bind_to_cpu(int cpu_id) {
    if (cpu_id >= CPU_SETSIZE) {
        std::ostringstream error;
        error << "Invalid CPU " << cpu_id
              << " > CPU_SETSIZE(" << CPU_SETSIZE
              << ")";
        throw std::runtime_error(error.str());
    }
    cpu_set_t set;
    CPU_ZERO(&set);
    CPU_SET(cpu_id, &set);
    if (pthread_setaffinity_np(pthread_self(), sizeof(set), &set)) {
        std::ostringstream error;
        error << "Failed to bind to CPU " << cpu_id << std::endl;
        throw std::runtime_error(error.str());
    }
}

ENYX_CORES_NAMESPACE_END
