#pragma once

#include <stddef.h>
#include <stdint.h>

#include <enyx/cores_c/symbol_visibility.h>

#include <enyx/cores_c/data_stream/sink.h>
#include <enyx/cores_c/data_stream/source.h>
#include <enyx/cores_c/data_stream/metadata.h>

/**
 *  This structure contains the UDP related source data
 */
struct enyx_udp_source_metadata
{
    /// Metadata chain
    enyx_data_stream_metadata metadata;

    /// The UDP session id
    uint32_t session_id;

    /// The UDP message flags
    uint8_t flags;

    /// Peer IP address
    uint32_t remote_ip;

    /// Peer Port
    uint16_t remote_port;
};

/// Alias shortchut
typedef struct enyx_udp_source_metadata enyx_udp_source_metadata;


/**
 * UDP source callback to invoke when data to be decoded is available.
 *
 * @param data: The UDP data to decode
 * @param size: Data size
 * @param metadata: Metadata associated with passed data
 * @param opaque: Opaque pointer to UDP source
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_udp_on_data(uint8_t const * data,
                 uint32_t size,
                 void const  * metadata,
                 void * opaque);

/**
 *  This structure contains the UDP related data
 */
struct enyx_udp_sink_metadata
{
    /// Metadata chain
    enyx_data_stream_metadata metadata;

    /// The UDP session id
    uint32_t session_id;

    /// The UDP message flags
    uint8_t flags;
};

/// Alias shortchut
typedef struct enyx_udp_sink_metadata enyx_udp_sink_metadata;

/**
 * Create a @p udp_sink that send to @p data_sink
 *
 * @param udp_sink The UDP sink to create
 * @param data_sink The sink of the UDP data
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_udp_create_sink(enyx_data_stream_sink * udp_sink,
                     enyx_data_stream_sink * data_sink);
