/// @file header.h
#pragma once

#include <assert.h>
#include <stdint.h>

/// The version of the TCP header protocol
#define ENYX_TCP_HEADER_VERSION_1 (1U)

/// The mask of the TCP reset flag
#define ENYX_TCP_HEADER_FLAG_RESET (1U << 2)

/**
 *  This structure represents the header used to exchange with the TCP TOE
 *
 *  Is used internally by the TCP IO Source & Sink.
 *
 *  A user can use it directly if he can't leverage on the source/sink
 *  API for some reason.
 */
typedef struct {
    /// The byte size of this header + payload
    uint16_t size;

    /// The version of the header
    uint8_t version;

    /// The flag associated with the current message
    uint8_t flags;

    /// The TCP session id concerned by the current message
    uint32_t session_id;
} enyx_tcp_header;
